CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	IF EXISTS (SELECT 1 FROM information_schema.columns 
					WHERE table_name= 'v_nfce_env') THEN 
		DROP VIEW v_nfce_env;
		RAISE NOTICE 'v_nfce_env Dropada.';
	END IF;
	
	CREATE OR REPLACE VIEW public.v_nfce_env
	AS SELECT vd.cd_emp,
		vd.cd_filial,
		vd.cd_cx,
		vd.cd_vd,
		vd.dt_vd,
		vd.nr_ecf,
		vd.cd_cli,
		vd.cgc_cpf,
		vd.nm_cli,
		vd.vlr_desc,
		vd.vlr_dinh,
		vd.vlr_chqs,
		( SELECT COALESCE(sum(tef.vl_cartao), 0::numeric) AS vl_cartao
			FROM pdv_vd_tef tef
			WHERE tef.cd_emp = vd.cd_emp AND tef.cd_filial = vd.cd_filial AND tef.cd_vd = vd.cd_vd AND tef.st_transacao <> 2::numeric AND tef.tp_adm <> 6) AS vlr_cartao,
		( SELECT COALESCE(sum(cred.vl_parc), 0::numeric) AS vl_crediario
			FROM pdv_vd_cred cred
			WHERE cred.cd_emp = vd.cd_emp AND cred.cd_filial = vd.cd_filial AND cred.cd_vd = vd.cd_vd) AS vlr_crediario,
		vd.vlr_tickets,
		vd.vlr_conv,
		vd.vlr_dup,
		vd.vlr_ncc,
		vd.st_vd,
		vd.vlr_conv_pbm,
		( SELECT COALESCE(sum(it_1.vlr_liq_it), 0::numeric) AS vlr_liq_it
			FROM pdv_vd_it it_1
			WHERE it_1.cd_emp = vd.cd_emp AND it_1.cd_filial = vd.cd_filial AND it_1.cd_vd = vd.cd_vd AND it_1.st_it = 1::numeric) AS vlr_to_liq_it,
		( SELECT COALESCE(sum(tef.vl_cartao), 0::numeric) AS "coalesce"
			FROM pdv_vd_tef tef
			WHERE tef.cd_emp = vd.cd_emp AND tef.cd_filial = vd.cd_filial AND tef.cd_vd = vd.cd_vd AND tef.st_transacao <> 2::numeric AND tef.tp_adm <> 6 AND ("substring"(tef.cod_modalidade::text, 1, 2) = '01'::text OR "substring"(tef.cod_modalidade::text, 1, 2) = '03'::text)) AS vlr_cartao_debito,
		( SELECT COALESCE(sum(tef.vl_cartao), 0::numeric) AS "coalesce"
			FROM pdv_vd_tef tef
			WHERE tef.cd_emp = vd.cd_emp AND tef.cd_filial = vd.cd_filial AND tef.cd_vd = vd.cd_vd AND tef.st_transacao <> 2::numeric AND tef.tp_adm <> 6 AND "substring"(tef.cod_modalidade::text, 1, 2) = '02'::text) AS vlr_cartao_credito,
		( SELECT COALESCE(sum(it_1.vlr_liq_it), 0::numeric) - vd.vlr_desc
			FROM pdv_vd_it it_1
			WHERE it_1.cd_emp = vd.cd_emp AND it_1.cd_filial = vd.cd_filial AND it_1.cd_vd = vd.cd_vd AND it_1.st_it = 1::numeric) AS vlr_to_liq_vd,
		( SELECT COALESCE(sum(it_1.vlr_tot_it), 0::numeric) AS vlr_tot_it
			FROM pdv_vd_it it_1
			WHERE it_1.cd_emp = vd.cd_emp AND it_1.cd_filial = vd.cd_filial AND it_1.cd_vd = vd.cd_vd AND it_1.st_it = 1::numeric) AS vlr_to_bruto_it,
		it.cd_it,
		it.cd_barras AS ean,
		it.cd_prod,
			CASE
				WHEN COALESCE(it.ds_prod_vd, ''::character varying)::text = ''::text THEN prod.ds_usual
				ELSE it.ds_prod_vd
			END AS ds_prod,
		prod.ncm_prod,
		med.ds_un AS cd_un_vd,
		it.qt_it,
		it.vlr_it,
		it.vlr_tot_it,
		it.vlr_desc_it,
		it.vlr_liq_it,
		it.cd_trib_fc,
		it.tx_icms_it,
		it.tx_red_it,
		it.st_it,
		it.tipo_imposto,
		it.cd_vend,
		it.vlr_desc_tot_rat,
		vd.cd_nf_serie,
		vd.cd_usu,
		vd.vlr_imposto,
		vd.vlr_imposto_uf,
		vd.vlr_imposto_mun,
		vd.inf_cpl_nfce,
		vd.homolog_nfce,
		vd.url_danfe_nfce,
		nfce.chv_nfce,
		nfce.aut_nfce,
		nfce.sts_pend,
		nfce.ds_motivo,
		nfce.dt_cad AS dt_emi,
		vd.vlr_troco,
		nfce.xml_nfce,
		e.cod_ativacao_mfe,
		e.signacmfe,
		vd.end_cli,
		it.cd_prod_kit,
		it.nr_cest
		FROM pdv_vd vd
			JOIN pdv_vd_it it ON vd.cd_emp = it.cd_emp AND vd.cd_filial = it.cd_filial AND vd.cd_vd = it.cd_vd
			JOIN est_nfce_env nfce ON vd.cd_emp = nfce.cd_emp AND vd.cd_filial = nfce.cd_filial AND vd.cd_nf_serie::text = nfce.cd_nf_serie::text AND vd.nr_ecf = nfce.cd_nf::numeric
			JOIN est_prod prod ON it.cd_emp = prod.cd_emp AND it.cd_prod = prod.cd_prod
			LEFT JOIN est_prod_un_med med ON prod.cd_emp = med.cd_emp AND prod.cd_un_vd = med.cd_ctr_un
			JOIN pdv_cx e ON e.cd_emp = vd.cd_emp AND e.cd_cx = vd.cd_cx AND e.cd_filial = vd.cd_filial;
	
	RAISE NOTICE 'v_nfce_env Recriada.';

END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();
